#ifndef _TPM_20_UI
#define _TPM_20_UI
#include "TpmTIS.h"
//#include "Tpm20.h"
#include "Tpm20_Types.h"
#include "TPM20Info.h"
//#include "ShellLib.h"


typedef struct _OPTIONAL_ARGUMENTS {
	UINT32 		verboseLevel;
	BOOLEAN		responseFile;
	BOOLEAN		responseFileAppend;
} OPTIONAL_ARGUMENTS;



//Bill test code


//added for compile
#define PROV2_NUM_INDEX 2
#define ALGS_SUPPORTED 2

#define PROV1_MAX_INDEXES		8	//should not see more than 8 indexes
#define PROV2_MAX_ALGS			8	//should not see more than 8 algorithms
#define PROV2_MAX_INDEXES		8	//should not see more than 8 indexes
#define PROV_MAX_RESPONSE		250	//maximum size for a response (min = 30 +(2*MAX_DIGEST))
#define TPM_ORD_NV_ReadValue 	0x000000CF	//Command Code
#define TPM1_READ_CMD_SIZE 		22	// size of TPM1.2 NV Read command
#define TPM_ORD_NV_WriteValue 	0x000000CD	//Command Code
#define TPM1_WRITE0_CMD_SIZE 	22	// size of TPM1.2 NV Write command for zero data length
#define TPM_TAG_RQU_COMMAND 	0x00C1		//Command Tag
#define PROV_SEND_SUCCESS 		0	//TPM Send successful
#define PROV_SEND_FAILED 		1	//TPM Send failed

//Tool error codes
#define GENERAL_ERROR			-1
#define UNSUPPORTED_OPERATION	-2
#define FILE_ERROR				-3
#define INDEX_DOESNT_EXIST		-4


// Endian Conversion Macros: bigEndian <--> littleEndian 
#define E16(x) \
  (((UINT16)(x) << 8) | ((UINT16)(x) >> 8))
#define E32(x) \
  (UINT32)((((UINT32)(x)) >> 24) |  \
           (((x) >> 8) & 0xff00) |  \
           ((x) << 24) |  \
           (((x) & 0xff00) << 8))

typedef struct {// Generic TPM response
	UINT16	tag;	
	UINT32	responseSize;	
	UINT32	responseCode;	
	BYTE	responseParams[PROV_MAX_RESPONSE-10];	
} TPM_RESPONSE;

typedef struct {	//Definition for an Index
	UINT32	nvIndex;	// Index handle
	BOOL	bWrite;	// Indicates if BIOS writes the data
	BOOL	bWriteProtect;	// Indicates if BIOS write-protects the data
	UINT32	createCmdSize;	// size of TPM command to create the index
	void	*createCmd;	// TPM command to create the index
	UINT32	writeCmdSize;	// size of TPM command to write the index
	void	*writeCmd;	// TPM command to Write the index
} INDEX_INFO;
	
typedef struct {	//OEM provided Provisioning Parameters
	UINT8	numIndexes;	// Number of indexes to create
	INDEX_INFO	iParams[PROV1_MAX_INDEXES];	// Array of TPM1.2 index parameters 
} PROV1_TABLE;

typedef struct {	// Provisioning Parameters per Hash Alg
	UINT16	hashAlgID;	// TPM_ALG_SHA256 = 0x000B, TPM_ALG_SHA1=0x0004
	UINT16	hashDigestSize;	// 20 if HashAlgID==SHA1 or 32 if ==SHA256/SM3
	UINT16	SetPhPolSize;	// size of SetPhPol command
	void 	*SetPhPolicy;	// pointer to command that sets PH authPolicy 
	UINT8	numIndexes;	// Number of indexes to create
	INDEX_INFO	*iParams[PROV2_NUM_INDEX];	// Array of pointers to index parameters for this algorithm
} PROV2_PARAMS;

typedef struct {	// Provisioning table
	UINT8	numAlgs;	// must equal ALGS_SUPPORTED
	PROV2_PARAMS	*alg[ALGS_SUPPORTED];	// Array of pointers to alg parameters
} PROV2TABLE;

// TPM 1.2 Commands  
typedef struct {	// TPM_NV_WriteValue command
	UINT16	tag;	// = E16(0x00C1) { TPM_TAG_RQU_COMMAND}
	UINT32	paramSize;	// = E32( 22)   TPM1_WRITE0_CMD_SIZE
	UINT32	ordinal;	// = E32(0x000000CD) { TPM_ORD_NV_WriteValue}
	UINT32	nvIndex;	// = E32(nvIndex) 	
	UINT32	offset;	// starting offset to write
	UINT32	writeLength;	// length of data to write
} NV_WRITEVALUE;
//NV_WRITEVALUE  nvWriteCmd = { E16(0x00C1), E32(22),  E32(TPM_ORD_NV_WriteValue), 0,0,0 } 


typedef struct {	// TPM_NV_ReadValue command
	UINT16	tag;	// = E16(0x00C1) { TPM_TAG_RQU_COMMAND}
	UINT32	paramSize;	// = E32( 22)  TPM1_WREAD_CMD_SIZE
	UINT32	ordinal;	// = E32(0x000000CF) { TPM_ORD_NV_ReadValue}
	UINT32	nvIndex;	// = E32(nvIndex) 	
	UINT32	offset;	// starting offset to read
	UINT32	readLength;	// length of data to read
} NV_READVALUE;
//NV_READVALUE	nvReadCmd = { E16(0x00C1), E32(22),  E32(TPM_ORD_NV_ReadValue), 0,0,0 } 

// TPM 2.0 Commands  
typedef struct {	// TPM2_NV_ReadPublic command
	UINT16	tag;	// = E16(0x8001) {TPM_ST_NO_SESSIONS}
	UINT32	commandSize;	// = E32( 0x000E)  {14 bytes}
	UINT32	commandCode;	// = E32(0x00000169) {TPM_CC_NV_ReadPublic}
	UINT32	nvIndex;	// = E32(nvIndex) 
} NV_READPUB;
//NV_READPUB	nvPubCmd = { E16(0x8001), E32(14),  E32(0x00000169), E32(nvIndex) } 

typedef struct {	// TPM2_NV_WriteLock command
	UINT16	tag;	// = E16(0x8002) TPM_ST_SESSIONS
	UINT32	commandSize;	// = E32(31) 
	UINT32	commandCode;	// = E32(0x00000138) TPM_CC_NV_WriteLock
	UINT32	authHandle;	// = E32(nvIndex)	
	UINT32	nvIndex;	// = E32(nvIndex)
	UINT32	authorizationSize;	// = E32(9)
	UINT32	sessionHandle;	// = E32(0x40000009) TPM_RS_PW
	UINT16	nonceSize;	// = 0x0000;	// EMPTY
	UINT8	sessionAttributes;	// = 0x00;
	UINT16	hmacSize;	// = 0x0000;	// EMPTY
} NV_WRITELOCK;
//NV_WRITELOCK	lockCmd = { E16(0x8002), E32(31), E32(0x00000138),  	E32(nvIndex), E32(nvIndex),  E32(9), E32(0x40000009), 0, 0, 0 }



//Prototypes
void	Tpm1Prov( void );  //performs TPM 1.2 provisioning
void	Tpm2Prov( void );  //performs TPM 2.0 provisioning
UINT32	TpmSend( UINT32 msgSize, VOID *command, UINT32 *RC ); 
BOOL IndexExist( UINT32 nvIndex );
BOOL WriteLock( UINT32 nvIndex );


//************************************************




/***************TPM Tool Menu Functions****************************/
BOOLEAN readSdefFile(T2T_SESSION_DEF_FILE *sDef, CHAR16 *sDefFile );
BOOLEAN readIdefFile(T2T_NV_DEF_FILE *iDef, CHAR16 *iDefFile );
BOOLEAN readPdefFile( T2T_POLICY_DEF_FILE *pDef, CHAR16 *pDefFile );
BOOLEAN readScfgFile(T2P_CONFIG_FILE *sCfg, CHAR16 *sCfgFile );
BOOLEAN readDigestListFile( T2T_DIGEST_LIST_FILE *digestListFile, CHAR16 *digestFile );
BOOLEAN readDatFile(UINT8 *rawData, UINT16 *dataSize, CHAR16 *dataFile);
BOOLEAN writeDatFile(UINT8 *rawData, UINT64 *dataSize, CHAR16 *dataFile);
BOOLEAN readPsetFile( T2T_POL_SET_FILE *pSet, CHAR16 *pSetFile );
BOOLEAN readKdefFile( T2T_K_DEF_FILE *kDef, CHAR16 *pKdefFile );
BOOLEAN readCdefFile( T2T_CDEF_FILE *cDef, CHAR16 *pCdefFile );
BOOLEAN readSobjFile( T2T_CDEF_FILE *cDef, CHAR16 *pCdefFile );

BOOLEAN updateScfgFile( T2P_CONFIG_FILE *sCfg, CHAR16 *sCfgFile );
BOOLEAN update_DIGEST_LIST_FILE( T2T_DIGEST_LIST_FILE *digestListFile, CHAR16 *digestFile );

UINT32 tpmOperation(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);

UINT32 TPM2_StartSession(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_SetActiveLocality(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_FlushSession(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_PolicyRestart(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvDefineSpace(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvWrite(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvVerifyDef(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvCompareData(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvReadPublic(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvRead(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvUndefineSpace(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NvUndefineSpecial(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_AssertPolicy(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_ImportValue(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_ExportValue(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_StorePolDigest(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_SavePolDigestDLF(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_SavePolDigest(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_SetPrimaryPolicy(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_PCRread(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_HierarchyChangeAuth(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_ClearOwner(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_ClearControl(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_DaLockReset(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_HashStart(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_HashUpdate(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_HashComplete(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_TPM2HMAC(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_GetCapability(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NVWriteLock(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_NVChangeAuth(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_GetRandom(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_CreatePrimary(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_Create(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_LoadExternal(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_Load(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_Execute(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_SaveKey(CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_LoadKey( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_LoadPublic( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_Duplicate( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_PolicyPCR( CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_CalcCpHash (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);
UINT32 TPM2_PT2 (CHAR16** operation, UINT8 numArgs, OPTIONAL_ARGUMENTS* optionalArgs);

/********************************************************************/



#endif //_TPM_20_UI